/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OpenApiHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiHandler.class);

    public void handle(RoutingContext context) {
        boolean isYaml = this.isYamlRequest(context);
        String contentType = isYaml ? "application/yaml" : "application/json";
        String fileName = isYaml ? "openapi.yaml" : "openapi.json";
        this.loadGeneratedOpenApiSpec(context.vertx(), fileName).onSuccess(buffer -> context.response().putHeader("Content-Type", contentType).end(buffer)).onFailure(throwable -> {
            LOGGER.error("Unable to read specification", throwable);
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "Unable to find specification"));
        });
    }

    private Future<Buffer> loadGeneratedOpenApiSpec(Vertx vertx, String fileName) {
        FileSystem fileSystem = vertx.fileSystem();
        return fileSystem.readFile("openapi/" + fileName).recover(cause -> fileSystem.readFile("server/build/resources/main/openapi/" + fileName)).recover(cause -> fileSystem.readFile("build/resources/main/openapi/" + fileName)).recover(cause -> fileSystem.readFile("../server/build/resources/main/openapi/" + fileName));
    }

    private boolean isYamlRequest(RoutingContext context) {
        String path = context.request().path();
        if (path != null && path.endsWith(".yaml")) {
            return true;
        }
        String acceptHeader = context.request().getHeader("Accept");
        return acceptHeader != null && acceptHeader.contains("application/yaml");
    }
}

