/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.inject.Singleton;
import org.apache.cassandra.sidecar.db.schema.CassandraSystemTableSchema;
import org.apache.cassandra.sidecar.exceptions.SchemaUnavailableException;
import org.jetbrains.annotations.NotNull;

@Singleton
public class SystemViewsSchema
extends CassandraSystemTableSchema {
    protected static final String SYSTEM_VIEWS_KEYSPACE_NAME = "system_views";
    protected static final String SYSTEM_VIEWS_SETTINGS_TABLE_NAME = "settings";
    private PreparedStatement selectSettings;

    protected String keyspaceName() {
        return SYSTEM_VIEWS_KEYSPACE_NAME;
    }

    protected String tableName() {
        return SYSTEM_VIEWS_SETTINGS_TABLE_NAME;
    }

    public PreparedStatement selectSettings() throws SchemaUnavailableException {
        this.ensureSchemaAvailable();
        return this.selectSettings;
    }

    protected void prepareStatements(@NotNull Session session) {
        this.selectSettings = session.prepare("SELECT name, value FROM system_views.settings WHERE name IN ?");
    }

    protected void ensureSchemaAvailable() throws SchemaUnavailableException {
        if (this.selectSettings == null) {
            throw new SchemaUnavailableException(this.keyspaceName(), this.tableName());
        }
    }
}

