/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.config.S3ClientConfiguration;
import org.apache.cassandra.sidecar.config.S3ProxyConfiguration;
import org.apache.cassandra.sidecar.config.yaml.S3ProxyConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ClientConfigurationImpl
implements S3ClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ClientConfigurationImpl.class);
    public static final String DEFAULT_THREAD_NAME_PREFIX = "s3-client";
    public static final String PROXY_PROPERTY = "proxy_config";
    public static final String API_CALL_TIMEOUT = "api_call_timeout";
    public static final String RANGE_GET_OBJECT_BYTES_SIZE = "range_get_object_bytes_size";
    public static final String THREAD_KEEP_ALIVE = "thread_keep_alive";
    public static final String CONCURRENCY = "concurrency";
    public static final String THREAD_NAME_PREFIX = "thread_name_prefix";
    public static final SecondBoundConfiguration DEFAULT_THREAD_KEEP_ALIVE = SecondBoundConfiguration.parse((String)"60s");
    public static final int DEFAULT_S3_CLIENT_CONCURRENCY = 4;
    public static final MillisecondBoundConfiguration DEFAULT_API_CALL_TIMEOUT = MillisecondBoundConfiguration.parse((String)"60s");
    public static final MillisecondBoundConfiguration MINIMUM_API_CALL_TIMEOUT = MillisecondBoundConfiguration.parse((String)"10s");
    public static final int DEFAULT_RANGE_GET_OBJECT_BYTES_SIZE = 0x500000;
    @JsonProperty(value="thread_name_prefix")
    protected final String threadNamePrefix;
    @JsonProperty(value="concurrency")
    protected final int concurrency;
    protected SecondBoundConfiguration threadKeepAlive;
    @JsonProperty(value="range_get_object_bytes_size")
    protected final int rangeGetObjectBytesSize;
    protected MillisecondBoundConfiguration apiCallTimeout;
    @JsonProperty(value="proxy_config")
    protected final S3ProxyConfiguration proxyConfig;

    public S3ClientConfigurationImpl() {
        this(DEFAULT_THREAD_NAME_PREFIX, 4, DEFAULT_THREAD_KEEP_ALIVE, 0x500000, DEFAULT_API_CALL_TIMEOUT, new S3ProxyConfigurationImpl());
    }

    public S3ClientConfigurationImpl(String threadNamePrefix, int concurrency, SecondBoundConfiguration threadKeepAlive, int rangeGetObjectBytesSize, MillisecondBoundConfiguration apiCallTimeout, S3ProxyConfiguration proxyConfig) {
        Preconditions.checkArgument((apiCallTimeout.compareTo((DurationSpec)MINIMUM_API_CALL_TIMEOUT) > 0 ? 1 : 0) != 0, () -> String.format("apiCallTimeout cannot be smaller than %s. Configured: %s", MINIMUM_API_CALL_TIMEOUT, apiCallTimeout));
        this.threadNamePrefix = threadNamePrefix;
        this.concurrency = concurrency;
        this.threadKeepAlive = threadKeepAlive;
        this.rangeGetObjectBytesSize = rangeGetObjectBytesSize;
        this.proxyConfig = proxyConfig;
        this.apiCallTimeout = apiCallTimeout;
    }

    @Override
    @JsonProperty(value="thread_name_prefix")
    @NotNull
    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    @Override
    @JsonProperty(value="concurrency")
    public int concurrency() {
        return this.concurrency;
    }

    @Override
    @JsonProperty(value="thread_keep_alive")
    public SecondBoundConfiguration threadKeepAlive() {
        return this.threadKeepAlive;
    }

    @JsonProperty(value="thread_keep_alive")
    public void setThreadKeepAlive(SecondBoundConfiguration threadKeepAlive) {
        this.threadKeepAlive = threadKeepAlive;
    }

    @JsonProperty(value="thread_keep_alive_seconds")
    @Deprecated
    public void setThreadKeepAliveSeconds(long threadKeepAliveSeconds) {
        LOGGER.warn("'thread_keep_alive_seconds' is deprecated, use '{}' instead", (Object)THREAD_KEEP_ALIVE);
        this.setThreadKeepAlive(new SecondBoundConfiguration(threadKeepAliveSeconds, TimeUnit.SECONDS));
    }

    @Override
    @JsonProperty(value="range_get_object_bytes_size")
    public int rangeGetObjectBytesSize() {
        return this.rangeGetObjectBytesSize;
    }

    @Override
    @JsonProperty(value="api_call_timeout")
    public MillisecondBoundConfiguration apiCallTimeout() {
        return this.apiCallTimeout;
    }

    @JsonProperty(value="api_call_timeout")
    public void setApiCallTimeout(MillisecondBoundConfiguration apiCallTimeout) {
        this.apiCallTimeout = apiCallTimeout;
    }

    @JsonProperty(value="api_call_timeout_millis")
    @Deprecated
    public void setApiCallTimeoutMillis(long apiCallTimeoutMillis) {
        LOGGER.warn("'api_call_timeout_millis' is deprecated, use 'api_call_timeout' instead");
        this.setApiCallTimeout(new MillisecondBoundConfiguration(apiCallTimeoutMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="proxy_config")
    @NotNull
    public S3ProxyConfiguration proxyConfig() {
        return this.proxyConfig;
    }
}

