/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;

public class JavaFieldsToFDCConverter {
    private Field[] fields;

    public JavaFieldsToFDCConverter(Field[] fields) {
        this.fields = fields;
    }

    public List<FieldDescriptionComposite> convertFields() {
        ArrayList<FieldDescriptionComposite> fdcList = new ArrayList<FieldDescriptionComposite>();
        for (Field field : this.fields) {
            FieldDescriptionComposite fdc = new FieldDescriptionComposite();
            fdc.setFieldName(field.getName());
            fdc.setModifierType(Modifier.toString(field.getModifiers()));
            this.attachHandlerChainAnnotation(fdc, field);
            this.attachWebServiceRefAnnotation(fdc, field);
        }
        return fdcList;
    }

    private void attachHandlerChainAnnotation(FieldDescriptionComposite fdc, Field field) {
        ConverterUtils.attachHandlerChainAnnotation(fdc, field);
    }

    private void attachWebServiceRefAnnotation(FieldDescriptionComposite fdc, Field field) {
        ConverterUtils.attachWebServiceRefAnnotation(fdc, field);
    }
}

