/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.Mapper;
import org.apache.axiom.core.NodeIterator;
import org.apache.axiom.core.Semantics;

public abstract class AbstractNodeIterator<T extends CoreNode, S>
implements NodeIterator<S> {
    private final CoreParentNode startNode;
    private final Axis axis;
    private final Class<T> type;
    private final Mapper<S, ? super T> mapper;
    private final Semantics semantics;
    private T currentNode;
    private CoreParentNode currentParent;
    private T nextNode;
    private boolean hasNext;
    private int depth;

    public AbstractNodeIterator(CoreParentNode startNode, Axis axis, Class<T> type, Mapper<S, ? super T> mapper, Semantics semantics) {
        this.startNode = startNode;
        this.axis = axis;
        this.type = type;
        this.mapper = mapper;
        this.semantics = semantics;
    }

    protected abstract boolean matches(T var1) throws CoreModelException;

    private void computeNext(Axis axis) {
        block15: {
            Object node = this.currentNode;
            if (node instanceof CoreChildNode && ((CoreChildNode)node).coreGetParent() != this.currentParent) {
                throw new ConcurrentModificationException("The current node has been removed using a method other than Iterator#remove()");
            }
            try {
                CoreNode candidate;
                do {
                    block1 : switch (axis) {
                        case CHILDREN: {
                            if (node == null) {
                                node = this.startNode.coreGetFirstChild();
                                break;
                            }
                            node = ((CoreChildNode)node).coreGetNextSibling();
                            break;
                        }
                        case DESCENDANTS: 
                        case DESCENDANTS_OR_SELF: {
                            if (node == null) {
                                if (axis == Axis.DESCENDANTS) {
                                    node = this.startNode.coreGetFirstChild();
                                    ++this.depth;
                                    break;
                                }
                                node = this.startNode;
                                break;
                            }
                            boolean visitChildren = true;
                            while (true) {
                                CoreChildNode firstChild;
                                if (visitChildren && node instanceof CoreParentNode && this.semantics.isParentNode(node.coreGetNodeType()) && (firstChild = ((CoreParentNode)node).coreGetFirstChild()) != null) {
                                    ++this.depth;
                                    node = firstChild;
                                    break block1;
                                }
                                if (this.depth == 0) {
                                    node = null;
                                    break block1;
                                }
                                CoreChildNode nextSibling = ((CoreChildNode)node).coreGetNextSibling();
                                if (nextSibling != null) {
                                    node = nextSibling;
                                    break block1;
                                }
                                --this.depth;
                                node = ((CoreChildNode)node).coreGetParent();
                                visitChildren = false;
                            }
                        }
                    }
                    if (node != null) continue;
                    this.nextNode = null;
                    break block15;
                } while (!this.type.isInstance(node) || !this.matches(candidate = (CoreNode)this.type.cast(node)));
                this.nextNode = candidate;
            }
            catch (CoreModelException ex) {
                throw this.semantics.toUncheckedException(ex);
            }
        }
        this.hasNext = true;
    }

    @Override
    public final boolean hasNext() {
        if (!this.hasNext) {
            this.computeNext(this.axis);
        }
        return this.nextNode != null;
    }

    @Override
    public final S next() {
        if (this.hasNext()) {
            this.currentNode = this.nextNode;
            this.currentParent = this.currentNode instanceof CoreChildNode ? ((CoreChildNode)this.currentNode).coreGetParent() : null;
            this.hasNext = false;
            S mapped = this.mapper.map(this.currentNode);
            if (mapped != this.currentNode && mapped instanceof CoreNode) {
                this.currentNode = (CoreNode)this.type.cast(mapped);
            }
            return mapped;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        if (this.currentNode == null) {
            throw new IllegalStateException();
        }
        this.computeNext(Axis.CHILDREN);
        if (this.currentNode instanceof CoreChildNode) {
            ((CoreChildNode)this.currentNode).coreDetach(this.semantics);
        }
        this.currentNode = null;
    }

    @Override
    public final void replace(CoreChildNode newNode) throws CoreModelException {
        this.computeNext(Axis.CHILDREN);
        ((CoreChildNode)this.currentNode).coreReplaceWith(newNode, this.semantics);
    }
}

